//=============================================================================
// This trigger, when triggered, changes the properties of a target actor
// this can be used by being triggered or by being touched.
//=============================================================================
class PropertyChangeTrigger extends Trigger;

var() actor ChangeTarget;
var() string PropertiesToChange[5];
var() string ChangePropertiesTo[5];
//=============================================================================
// AI related functions

function Trigger(Actor Other, Pawn EventInstigator)
{
 ChangeTarget.SetPropertyText(PropertiesToChange[0], ChangePropertiesTo[0]);
 ChangeTarget.SetPropertyText(PropertiesToChange[1], ChangePropertiesTo[1]);
 ChangeTarget.SetPropertyText(PropertiesToChange[2], ChangePropertiesTo[2]);
 ChangeTarget.SetPropertyText(PropertiesToChange[3], ChangePropertiesTo[3]);
 ChangeTarget.SetPropertyText(PropertiesToChange[4], ChangePropertiesTo[4]);
}

function Touch(Actor Other)
{
 if (IsRelevant(Other))
 {
  if (Other.IsA('Pawn'))
  Trigger(Other, Pawn(Other));
  if (!Other.IsA('Pawn'))
  Trigger(Other, None);
 }
}

defaultproperties
{
     Texture=Texture'Engine.S_Trigger'
}
